"use client";

import { Button } from "@/components/ui/button";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import {
  Globe,
  Smartphone,
  Users,
  Database,
  Cloud,
  Layout,
  Server,
  ArrowRight,
  CheckCircle2,
  Sparkles,
  Code2
} from "lucide-react";
import { motion } from "framer-motion";
import Link from "next/link";

export default function DichVuPage() {
  const services = [
    {
      icon: Globe,
      title: "Web Development",
      description: "Phát triển ứng dụng web hiện đại, responsive và tối ưu hiệu suất",
      features: [
        "Single Page Application (SPA)",
        "Progressive Web App (PWA)",
        "E-commerce Platform",
        "Content Management System",
        "Admin Dashboard"
      ],
      tech: ["React", "Next.js", "Vue.js", "Angular"],
      gradient: "from-blue-500 to-cyan-500"
    },
    {
      icon: Smartphone,
      title: "Mobile Development",
      description: "Xây dựng ứng dụng di động đa nền tảng iOS & Android",
      features: [
        "Cross-platform App",
        "Native iOS App",
        "Native Android App",
        "Hybrid Mobile App",
        "Mobile UI/UX Design"
      ],
      tech: ["React Native", "Flutter", "Swift", "Kotlin"],
      gradient: "from-cyan-500 to-teal-500"
    },
    {
      icon: Code2,
      title: "Custom Software",
      description: "Giải pháp phần mềm tùy chỉnh theo nhu cầu riêng biệt",
      features: [
        "Enterprise Software",
        "Business Process Automation",
        "Legacy System Modernization",
        "Software Integration",
        "Custom CRM/ERP"
      ],
      tech: ["Java", "Python", ".NET", "Node.js"],
      gradient: "from-blue-600 to-blue-400"
    },
    {
      icon: Database,
      title: "API Development",
      description: "Thiết kế và phát triển API mạnh mẽ, bảo mật cao",
      features: [
        "RESTful API Design",
        "GraphQL API",
        "Microservices Architecture",
        "API Gateway",
        "API Documentation"
      ],
      tech: ["Node.js", "Express", "NestJS", "FastAPI"],
      gradient: "from-teal-500 to-emerald-500"
    },
    {
      icon: Cloud,
      title: "DevOps & Cloud",
      description: "Triển khai và quản lý hạ tầng cloud chuyên nghiệp",
      features: [
        "Cloud Infrastructure Setup",
        "CI/CD Pipeline",
        "Container Orchestration",
        "Monitoring & Logging",
        "Auto Scaling"
      ],
      tech: ["AWS", "Azure", "Docker", "Kubernetes"],
      gradient: "from-blue-500 to-indigo-500"
    },
    {
      icon: Users,
      title: "Team Augmentation",
      description: "Mở rộng đội ngũ với các chuyên gia giàu kinh nghiệm",
      features: [
        "Dedicated Developers",
        "Project-based Team",
        "Technical Consulting",
        "Code Review & Audit",
        "Training & Mentoring"
      ],
      tech: ["Full-stack", "Frontend", "Backend", "DevOps"],
      gradient: "from-cyan-600 to-blue-600"
    }
  ];

  const process = [
    {
      step: "01",
      title: "Tư Vấn & Phân Tích",
      description: "Lắng nghe nhu cầu, phân tích yêu cầu chi tiết, đề xuất giải pháp tối ưu",
      icon: Users
    },
    {
      step: "02",
      title: "Thiết Kế & Lập Kế Hoạch",
      description: "Thiết kế UI/UX, kiến trúc hệ thống, lập roadmap chi tiết",
      icon: Layout
    },
    {
      step: "03",
      title: "Phát Triển & Testing",
      description: "Code chất lượng cao, test tự động, review kỹ lưỡng",
      icon: Code2
    },
    {
      step: "04",
      title: "Triển Khai & Hỗ Trợ",
      description: "Deploy an toàn, monitoring 24/7, support liên tục",
      icon: Server
    }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative pt-32 pb-20 px-4 overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900" />
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25" />
        
        <div className="container mx-auto relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center max-w-4xl mx-auto"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Sparkles className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Dịch Vụ Chuyên Nghiệp</span>
            </div>
            <h1 className="text-5xl md:text-6xl font-bold mb-6">
              Dịch Vụ <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Của Chúng Tôi</span>
            </h1>
            <p className="text-xl text-slate-600 dark:text-slate-300 leading-relaxed">
              Giải pháp công nghệ toàn diện từ ý tưởng đến sản phẩm hoàn thiện, 
              đáp ứng mọi nhu cầu phát triển phần mềm của doanh nghiệp
            </p>
          </motion.div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto">
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {services.map((service, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="group relative"
              >
                <div className="relative bg-white dark:bg-slate-800 p-8 rounded-2xl border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 h-full shadow-lg hover:shadow-2xl group-hover:-translate-y-2">
                  <div className={`w-16 h-16 bg-gradient-to-br ${service.gradient} rounded-2xl flex items-center justify-center mb-6 shadow-lg group-hover:scale-110 transition-transform duration-300`}>
                    <service.icon className="w-8 h-8 text-white" />
                  </div>
                  
                  <h3 className="text-2xl font-bold mb-4 text-slate-900 dark:text-white group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">
                    {service.title}
                  </h3>
                  
                  <p className="text-slate-600 dark:text-slate-300 mb-6 leading-relaxed">
                    {service.description}
                  </p>

                  <div className="mb-6">
                    <h4 className="font-semibold text-slate-900 dark:text-white mb-3">Tính năng:</h4>
                    <ul className="space-y-2">
                      {service.features.map((feature, idx) => (
                        <li key={idx} className="flex items-start gap-2 text-sm text-slate-600 dark:text-slate-300">
                          <CheckCircle2 className="w-4 h-4 text-blue-600 mt-0.5 flex-shrink-0" />
                          {feature}
                        </li>
                      ))}
                    </ul>
                  </div>

                  <div>
                    <h4 className="font-semibold text-slate-900 dark:text-white mb-3">Công nghệ:</h4>
                    <div className="flex flex-wrap gap-2">
                      {service.tech.map((tech, idx) => (
                        <span key={idx} className="px-3 py-1 bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300 rounded-full text-xs font-medium">
                          {tech}
                        </span>
                      ))}
                    </div>
                  </div>

                  <div className="mt-6 flex items-center text-blue-600 dark:text-blue-400 font-medium opacity-0 group-hover:opacity-100 transition-opacity">
                    Tìm hiểu thêm <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-2 transition-transform" />
                  </div>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Process Section */}
      <section className="py-20 px-4 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900">
        <div className="container mx-auto max-w-6xl">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-4xl font-bold mb-4 text-slate-900 dark:text-white">
              Quy Trình Làm Việc
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300">
              Phương pháp chuyên nghiệp, minh bạch từng bước
            </p>
          </motion.div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            {process.map((item, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                whileHover={{ y: -5 }}
                className="relative group"
              >
                <div className="bg-white dark:bg-slate-800 rounded-2xl p-8 border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 h-full shadow-lg hover:shadow-2xl">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="text-5xl font-bold bg-gradient-to-br from-blue-500 to-cyan-500 bg-clip-text text-transparent">
                      {item.step}
                    </div>
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center shadow-lg shadow-blue-500/30 group-hover:scale-110 transition-transform">
                      <item.icon className="w-6 h-6 text-white" />
                    </div>
                  </div>
                  <h3 className="text-xl font-bold mb-3 text-slate-900 dark:text-white">
                    {item.title}
                  </h3>
                  <p className="text-slate-600 dark:text-slate-300 leading-relaxed">
                    {item.description}
                  </p>
                </div>
                {index < 3 && (
                  <div className="hidden lg:block absolute top-1/2 -right-4 z-20">
                    <ArrowRight className="w-8 h-8 text-blue-400" />
                  </div>
                )}
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 px-4 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-600 via-cyan-600 to-teal-600" />
        <div className="container mx-auto text-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
              Bắt Đầu Dự Án Của Bạn
            </h2>
            <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
              Liên hệ ngay để được tư vấn miễn phí và nhận báo giá chi tiết
            </p>
            <Link href="/lien-he">
              <Button size="lg" className="bg-white text-blue-600 hover:bg-blue-50 text-lg px-10 py-7 shadow-2xl">
                Liên Hệ Ngay <ArrowRight className="ml-2" />
              </Button>
            </Link>
          </motion.div>
        </div>
      </section>

      <Footer />
    </div>
  );
}

