"use client";

import { Button } from "@/components/ui/button";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import {
  ExternalLink,
  ArrowRight,
  Sparkles,
  ShoppingCart,
  GraduationCap,
  Heart,
  Briefcase,
  Smartphone,
  Globe,
  TrendingUp,
  Users
} from "lucide-react";
import { motion } from "framer-motion";
import Link from "next/link";

export default function DuAnPage() {
  const projects = [
    {
      title: "E-Commerce Platform",
      category: "Web Application",
      description: "Nền tảng thương mại điện tử đa kênh với hơn 10,000 sản phẩm, tích hợp thanh toán và quản lý kho hàng thông minh",
      image: "🛒",
      icon: ShoppingCart,
      tech: ["Next.js", "Node.js", "PostgreSQL", "Redis"],
      results: [
        "Tăng 300% doanh thu online",
        "Xử lý 50,000+ đơn hàng/tháng",
        "Thời gian tải trang < 2s"
      ],
      gradient: "from-blue-500 to-cyan-500"
    },
    {
      title: "Learning Management System",
      category: "Education Platform",
      description: "Hệ thống quản lý học tập trực tuyến với video streaming, quiz tương tác và theo dõi tiến độ học viên",
      image: "📚",
      icon: GraduationCap,
      tech: ["React", "Express", "MongoDB", "AWS"],
      results: [
        "10,000+ học viên hoạt động",
        "500+ khóa học",
        "Tỷ lệ hoàn thành 85%"
      ],
      gradient: "from-cyan-500 to-teal-500"
    },
    {
      title: "Healthcare Mobile App",
      category: "Mobile Application",
      description: "Ứng dụng chăm sóc sức khỏe kết nối bác sĩ và bệnh nhân, đặt lịch khám, tư vấn trực tuyến",
      image: "🏥",
      icon: Heart,
      tech: ["React Native", "Firebase", "Node.js", "Socket.io"],
      results: [
        "20,000+ người dùng",
        "5,000+ cuộc tư vấn/tháng",
        "Rating 4.8/5 trên App Store"
      ],
      gradient: "from-blue-600 to-blue-400"
    },
    {
      title: "HR Management System",
      category: "Enterprise Software",
      description: "Hệ thống quản lý nhân sự toàn diện: chấm công, tính lương, đánh giá KPI, quản lý nghỉ phép",
      image: "💼",
      icon: Briefcase,
      tech: ["Vue.js", "Laravel", "MySQL", "Docker"],
      results: [
        "Quản lý 1,000+ nhân viên",
        "Tiết kiệm 40% thời gian HR",
        "Tự động hóa 90% quy trình"
      ],
      gradient: "from-teal-500 to-emerald-500"
    },
    {
      title: "Food Delivery App",
      category: "Mobile Application",
      description: "Ứng dụng giao đồ ăn với tracking realtime, đa phương thức thanh toán, chương trình khuyến mãi",
      image: "🍔",
      icon: Smartphone,
      tech: ["Flutter", "Node.js", "PostgreSQL", "Google Maps"],
      results: [
        "30,000+ đơn hàng/ngày",
        "2,000+ nhà hàng đối tác",
        "Thời gian giao trung bình 25 phút"
      ],
      gradient: "from-blue-500 to-indigo-500"
    },
    {
      title: "Real Estate Portal",
      category: "Web Application",
      description: "Cổng thông tin bất động sản với tìm kiếm thông minh, tour 360°, tư vấn AI",
      image: "🏠",
      icon: Globe,
      tech: ["Next.js", "Python", "TensorFlow", "AWS"],
      results: [
        "50,000+ tin đăng",
        "100,000+ lượt truy cập/tháng",
        "Tăng 200% lead chất lượng"
      ],
      gradient: "from-cyan-600 to-blue-600"
    }
  ];

  const stats = [
    { number: "100+", label: "Dự Án Hoàn Thành", icon: TrendingUp },
    { number: "50+", label: "Khách Hàng Hài Lòng", icon: Users },
    { number: "99%", label: "Tỷ Lệ Thành Công", icon: Sparkles },
    { number: "24/7", label: "Hỗ Trợ Liên Tục", icon: Heart }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative pt-32 pb-20 px-4 overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900" />
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25" />
        
        <div className="container mx-auto relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center max-w-4xl mx-auto"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Sparkles className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Portfolio & Case Studies</span>
            </div>
            <h1 className="text-5xl md:text-6xl font-bold mb-6">
              Dự Án <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Tiêu Biểu</span>
            </h1>
            <p className="text-xl text-slate-600 dark:text-slate-300 leading-relaxed">
              Khám phá những dự án thành công mà chúng tôi đã thực hiện, 
              mang lại giá trị thực sự cho khách hàng
            </p>
          </motion.div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-12 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8 max-w-5xl mx-auto">
            {stats.map((stat, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="text-center"
              >
                <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg shadow-blue-500/30">
                  <stat.icon className="w-8 h-8 text-white" />
                </div>
                <div className="text-4xl font-bold bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent mb-2">
                  {stat.number}
                </div>
                <div className="text-sm text-slate-600 dark:text-slate-400 font-medium">{stat.label}</div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Projects Grid */}
      <section className="py-20 px-4 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900">
        <div className="container mx-auto">
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {projects.map((project, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="group relative"
              >
                <div className="relative bg-white dark:bg-slate-800 rounded-2xl border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 overflow-hidden shadow-lg hover:shadow-2xl group-hover:-translate-y-2">
                  {/* Project Image/Icon */}
                  <div className={`h-48 bg-gradient-to-br ${project.gradient} flex items-center justify-center text-8xl`}>
                    {project.image}
                  </div>

                  <div className="p-8">
                    <div className="flex items-center gap-3 mb-4">
                      <div className={`w-12 h-12 bg-gradient-to-br ${project.gradient} rounded-xl flex items-center justify-center shadow-lg`}>
                        <project.icon className="w-6 h-6 text-white" />
                      </div>
                      <div>
                        <h3 className="text-xl font-bold text-slate-900 dark:text-white">
                          {project.title}
                        </h3>
                        <p className="text-sm text-blue-600 dark:text-blue-400">{project.category}</p>
                      </div>
                    </div>

                    <p className="text-slate-600 dark:text-slate-300 mb-6 leading-relaxed">
                      {project.description}
                    </p>

                    <div className="mb-6">
                      <h4 className="font-semibold text-slate-900 dark:text-white mb-3 text-sm">Kết quả đạt được:</h4>
                      <ul className="space-y-2">
                        {project.results.map((result, idx) => (
                          <li key={idx} className="flex items-start gap-2 text-sm text-slate-600 dark:text-slate-300">
                            <Sparkles className="w-4 h-4 text-blue-600 mt-0.5 flex-shrink-0" />
                            {result}
                          </li>
                        ))}
                      </ul>
                    </div>

                    <div className="mb-6">
                      <h4 className="font-semibold text-slate-900 dark:text-white mb-3 text-sm">Công nghệ:</h4>
                      <div className="flex flex-wrap gap-2">
                        {project.tech.map((tech, idx) => (
                          <span key={idx} className="px-3 py-1 bg-blue-100 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300 rounded-full text-xs font-medium">
                            {tech}
                          </span>
                        ))}
                      </div>
                    </div>

                    <button className="w-full flex items-center justify-center gap-2 px-6 py-3 bg-gradient-to-r from-blue-600 to-cyan-600 hover:from-blue-700 hover:to-cyan-700 text-white rounded-xl font-medium transition-all group-hover:shadow-lg group-hover:shadow-blue-500/30">
                      Xem Chi Tiết <ExternalLink className="w-4 h-4" />
                    </button>
                  </div>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 px-4 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-600 via-cyan-600 to-teal-600" />
        <div className="container mx-auto text-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
              Dự Án Tiếp Theo Là Của Bạn?
            </h2>
            <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
              Hãy để chúng tôi biến ý tưởng của bạn thành hiện thực
            </p>
            <Link href="/lien-he">
              <Button size="lg" className="bg-white text-blue-600 hover:bg-blue-50 text-lg px-10 py-7 shadow-2xl">
                Bắt Đầu Dự Án <ArrowRight className="ml-2" />
              </Button>
            </Link>
          </motion.div>
        </div>
      </section>

      <Footer />
    </div>
  );
}

