"use client";

import { Button } from "@/components/ui/button";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import {
  Users,
  Award,
  Rocket,
  Heart,
  Shield,
  ArrowRight,
  Lightbulb,
  Globe,
  TrendingUp
} from "lucide-react";
import { motion } from "framer-motion";
import Link from "next/link";

export default function GioiThieuPage() {
  const values = [
    {
      icon: Heart,
      title: "Tận Tâm",
      description: "Đặt khách hàng làm trung tâm, lắng nghe và thấu hiểu nhu cầu"
    },
    {
      icon: Lightbulb,
      title: "Sáng Tạo",
      description: "Không ngừng đổi mới, tìm kiếm giải pháp tối ưu nhất"
    },
    {
      icon: Shield,
      title: "Chất Lượng",
      description: "Cam kết chất lượng cao trong từng dòng code"
    },
    {
      icon: TrendingUp,
      title: "Phát Triển",
      description: "Học hỏi liên tục, cập nhật công nghệ mới nhất"
    }
  ];


  const milestones = [
    { year: "2019", event: "Thành lập EZDEV" },
    { year: "2020", event: "Hoàn thành 20+ dự án" },
    { year: "2021", event: "Mở rộng đội ngũ 15+ thành viên" },
    { year: "2022", event: "Đạt 50+ khách hàng tin tưởng" },
    { year: "2023", event: "Ra mắt văn phòng mới" },
    { year: "2024", event: "100+ dự án thành công" }
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative pt-32 pb-20 px-4 overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900" />
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25" />
        
        <div className="container mx-auto relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center max-w-4xl mx-auto"
          >
            <h1 className="text-5xl md:text-6xl font-bold mb-6">
              Về <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">EZDEV</span>
            </h1>
            <p className="text-xl text-slate-600 dark:text-slate-300 leading-relaxed">
              Chúng tôi là đội ngũ chuyên gia công nghệ đam mê, với sứ mệnh mang đến 
              những giải pháp phần mềm tối ưu, giúp doanh nghiệp chuyển đổi số thành công
            </p>
          </motion.div>
        </div>
      </section>

      {/* Story Section */}
      <section className="py-20 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto max-w-6xl">
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <motion.div
              initial={{ opacity: 0, x: -30 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
            >
              <h2 className="text-4xl font-bold mb-6 text-slate-900 dark:text-white">
                Câu Chuyện Của <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Chúng Tôi</span>
              </h2>
              <div className="space-y-4 text-slate-600 dark:text-slate-300 leading-relaxed">
                <p>
                  EZDEV được thành lập vào năm 2019 bởi một nhóm kỹ sư phần mềm đam mê công nghệ. 
                  Chúng tôi bắt đầu với một tầm nhìn đơn giản: tạo ra những sản phẩm công nghệ 
                  chất lượng cao, giúp doanh nghiệp Việt Nam phát triển.
                </p>
                <p>
                  Sau 5 năm hoạt động, chúng tôi tự hào đã đồng hành cùng hơn 50 doanh nghiệp, 
                  từ startup đến tập đoàn lớn, trong hành trình chuyển đổi số của họ.
                </p>
                <p>
                  Với đội ngũ 20+ chuyên gia giàu kinh nghiệm, chúng tôi không ngừng học hỏi, 
                  cập nhật công nghệ mới để mang đến giá trị tốt nhất cho khách hàng.
                </p>
              </div>
            </motion.div>
            
            <motion.div
              initial={{ opacity: 0, x: 30 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              className="grid grid-cols-2 gap-4"
            >
              {[
                { icon: Users, number: "20+", label: "Chuyên Gia" },
                { icon: Rocket, number: "100+", label: "Dự Án" },
                { icon: Award, number: "50+", label: "Khách Hàng" },
                { icon: Globe, number: "5+", label: "Năm Kinh Nghiệm" }
              ].map((stat, index) => (
                <div key={index} className="bg-gradient-to-br from-blue-50 to-cyan-50 dark:from-slate-800 dark:to-blue-900/30 p-6 rounded-2xl border border-blue-100 dark:border-blue-800">
                  <stat.icon className="w-8 h-8 text-blue-600 mb-3" />
                  <div className="text-3xl font-bold bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent mb-1">
                    {stat.number}
                  </div>
                  <div className="text-sm text-slate-600 dark:text-slate-400">{stat.label}</div>
                </div>
              ))}
            </motion.div>
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="py-20 px-4 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900">
        <div className="container mx-auto max-w-6xl">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-4xl font-bold mb-4 text-slate-900 dark:text-white">
              Giá Trị Cốt Lõi
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300">
              Những nguyên tắc định hướng mọi hành động của chúng tôi
            </p>
          </motion.div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {values.map((value, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                whileHover={{ y: -5 }}
                className="bg-white dark:bg-slate-800 p-6 rounded-2xl border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all shadow-lg hover:shadow-xl"
              >
                <div className="w-14 h-14 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-blue-500/30">
                  <value.icon className="w-7 h-7 text-white" />
                </div>
                <h3 className="text-xl font-bold mb-2 text-slate-900 dark:text-white">{value.title}</h3>
                <p className="text-slate-600 dark:text-slate-300">{value.description}</p>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Timeline Section */}
      <section className="py-20 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto max-w-4xl">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-4xl font-bold mb-4 text-slate-900 dark:text-white">
              Hành Trình Phát Triển
            </h2>
          </motion.div>

          <div className="space-y-8">
            {milestones.map((milestone, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, x: index % 2 === 0 ? -30 : 30 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                className="flex items-center gap-6"
              >
                <div className="w-24 text-2xl font-bold bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">
                  {milestone.year}
                </div>
                <div className="w-4 h-4 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-full shadow-lg shadow-blue-500/50" />
                <div className="flex-1 bg-gradient-to-r from-blue-50 to-cyan-50 dark:from-slate-800 dark:to-blue-900/30 p-4 rounded-xl border border-blue-100 dark:border-blue-800">
                  <p className="text-slate-900 dark:text-white font-medium">{milestone.event}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 px-4 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-600 via-cyan-600 to-teal-600" />
        <div className="container mx-auto text-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">
              Sẵn Sàng Hợp Tác?
            </h2>
            <p className="text-xl text-white/90 mb-8 max-w-2xl mx-auto">
              Hãy để EZDEV đồng hành cùng bạn trong hành trình chuyển đổi số
            </p>
            <Link href="/lien-he">
              <Button size="lg" className="bg-white text-blue-600 hover:bg-blue-50 text-lg px-10 py-7 shadow-2xl">
                Liên Hệ Ngay <ArrowRight className="ml-2" />
              </Button>
            </Link>
          </motion.div>
        </div>
      </section>

      <Footer />
    </div>
  );
}

