"use client";

import { Button } from "@/components/ui/button";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import {
  Smartphone,
  Globe,
  Zap,
  Shield,
  Users,
  ArrowRight,
  CheckCircle2,
  Rocket,
  Sparkles,
  Award,
  HeadphonesIcon,
  Code2
} from "lucide-react";
import { motion } from "framer-motion";
import Link from "next/link";

export default function Home() {
  const services = [
    {
      icon: Globe,
      title: "Web Development",
      description: "Phát triển ứng dụng web hiện đại với React, Next.js, và các công nghệ tiên tiến nhất",
      gradient: "from-blue-500 to-cyan-500"
    },
    {
      icon: Smartphone,
      title: "Mobile Development",
      description: "Xây dựng ứng dụng di động đa nền tảng iOS & Android với React Native và Flutter",
      gradient: "from-cyan-500 to-teal-500"
    },
    {
      icon: Code2,
      title: "Custom Software",
      description: "Giải pháp phần mềm tùy chỉnh theo nhu cầu riêng biệt của doanh nghiệp",
      gradient: "from-blue-600 to-blue-400"
    },
    {
      icon: Zap,
      title: "API Development",
      description: "Thiết kế và phát triển RESTful API, GraphQL với hiệu suất cao và bảo mật tốt",
      gradient: "from-teal-500 to-emerald-500"
    },
    {
      icon: Shield,
      title: "DevOps & Cloud",
      description: "Triển khai và quản lý hạ tầng cloud, CI/CD, monitoring và scaling",
      gradient: "from-blue-500 to-indigo-500"
    },
    {
      icon: Users,
      title: "Team Augmentation",
      description: "Mở rộng đội ngũ phát triển với các chuyên gia giàu kinh nghiệm",
      gradient: "from-cyan-600 to-blue-600"
    }
  ];

  const features = [
    {
      icon: Rocket,
      title: "Giao Hàng Nhanh",
      description: "Phương pháp Agile giúp triển khai nhanh chóng và linh hoạt"
    },
    {
      icon: Award,
      title: "Chất Lượng Cao",
      description: "Code review nghiêm ngặt, testing tự động, đảm bảo chất lượng"
    },
    {
      icon: Sparkles,
      title: "Giải Pháp Sáng Tạo",
      description: "Tư duy đổi mới, áp dụng công nghệ mới nhất vào dự án"
    },
    {
      icon: HeadphonesIcon,
      title: "Hỗ Trợ 24/7",
      description: "Đội ngũ support luôn sẵn sàng hỗ trợ mọi lúc mọi nơi"
    }
  ];

  const techStack = [
    "React", "Next.js", "TypeScript", "Node.js",
    "Python", "PostgreSQL", "MongoDB", "AWS",
    "Docker", "Kubernetes", "React Native", "Flutter"
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative pt-32 pb-24 px-4 overflow-hidden">
        {/* Background Elements */}
        <div className="absolute inset-0 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900" />
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25 [mask-image:linear-gradient(0deg,transparent,black)]" />
        <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-blue-400/20 rounded-full blur-3xl" />
        <div className="absolute bottom-0 left-0 w-[500px] h-[500px] bg-cyan-400/20 rounded-full blur-3xl" />

        <div className="container mx-auto relative z-10">
          <div className="max-w-5xl mx-auto text-center">
            <motion.div
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6 }}
            >
              <motion.div
                initial={{ opacity: 0, scale: 0.9 }}
                animate={{ opacity: 1, scale: 1 }}
                transition={{ delay: 0.2 }}
                className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-8 border border-blue-200 dark:border-blue-800"
              >
                <Sparkles className="w-4 h-4 text-blue-600" />
                <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Đối Tác Công Nghệ Đáng Tin Cậy</span>
              </motion.div>

              <h1 className="text-5xl md:text-7xl lg:text-8xl font-bold mb-6 leading-tight">
                <span className="bg-gradient-to-r from-blue-600 via-cyan-600 to-teal-600 bg-clip-text text-transparent">
                  Biến Ý Tưởng
                </span>
                <br />
                <span className="text-slate-900 dark:text-white">
                  Thành Hiện Thực
                </span>
              </h1>

              <p className="text-xl md:text-2xl text-slate-600 dark:text-slate-300 mb-10 max-w-3xl mx-auto leading-relaxed">
                Đội ngũ chuyên gia phát triển phần mềm hàng đầu, mang đến giải pháp công nghệ
                <span className="font-semibold text-blue-600"> tối ưu và sáng tạo </span>
                cho doanh nghiệp của bạn
              </p>

              <div className="flex gap-4 justify-center flex-wrap mb-16">
                <Link href="/lien-he">
                  <Button size="lg" className="bg-gradient-to-r from-blue-600 to-cyan-600 hover:from-blue-700 hover:to-cyan-700 text-lg px-8 py-7 shadow-xl shadow-blue-500/30 hover:shadow-2xl hover:shadow-blue-500/40 transition-all">
                    Bắt Đầu Dự Án <ArrowRight className="ml-2 w-5 h-5" />
                  </Button>
                </Link>
                <Link href="/du-an">
                  <Button size="lg" variant="outline" className="text-lg px-8 py-7 border-2 border-blue-200 hover:border-blue-400 hover:bg-blue-50 dark:border-blue-800 dark:hover:bg-blue-950">
                    Xem Portfolio
                  </Button>
                </Link>
              </div>
            </motion.div>

            {/* Stats */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4, duration: 0.6 }}
              className="grid grid-cols-2 md:grid-cols-4 gap-8 max-w-4xl mx-auto"
            >
              {[
                { number: "100+", label: "Dự Án Hoàn Thành", icon: CheckCircle2 },
                { number: "50+", label: "Khách Hàng Tin Tưởng", icon: Users },
                { number: "20+", label: "Chuyên Gia", icon: Award },
                { number: "5+", label: "Năm Kinh Nghiệm", icon: Rocket }
              ].map((stat, index) => (
                <motion.div
                  key={index}
                  className="relative group"
                  whileHover={{ y: -5 }}
                  transition={{ duration: 0.2 }}
                >
                  <div className="bg-white dark:bg-slate-800 rounded-2xl p-6 shadow-lg border border-blue-100 dark:border-blue-900/50 group-hover:shadow-xl group-hover:border-blue-300 dark:group-hover:border-blue-700 transition-all">
                    <stat.icon className="w-8 h-8 text-blue-600 mx-auto mb-3" />
                    <div className="text-4xl font-bold bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent mb-2">
                      {stat.number}
                    </div>
                    <div className="text-sm text-slate-600 dark:text-slate-400 font-medium">{stat.label}</div>
                  </div>
                </motion.div>
              ))}
            </motion.div>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section id="services" className="py-24 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-16"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Zap className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Dịch Vụ Chuyên Nghiệp</span>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-slate-900 dark:text-white">
              Giải Pháp Công Nghệ <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Toàn Diện</span>
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
              Từ ý tưởng đến sản phẩm hoàn thiện, chúng tôi đồng hành cùng bạn trong mọi giai đoạn
            </p>
          </motion.div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {services.map((service, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="group relative"
              >
                <div className="absolute inset-0 bg-gradient-to-r opacity-0 group-hover:opacity-100 transition-opacity rounded-2xl blur-xl -z-10"
                     style={{ background: `linear-gradient(to right, var(--tw-gradient-stops))` }} />
                <div className="relative bg-white dark:bg-slate-800 p-8 rounded-2xl border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 h-full shadow-lg hover:shadow-2xl group-hover:-translate-y-2">
                  <div className={`w-16 h-16 bg-gradient-to-br ${service.gradient} rounded-2xl flex items-center justify-center mb-6 shadow-lg group-hover:scale-110 transition-transform duration-300`}>
                    <service.icon className="w-8 h-8 text-white" />
                  </div>
                  <h3 className="text-2xl font-bold mb-4 text-slate-900 dark:text-white group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors">
                    {service.title}
                  </h3>
                  <p className="text-slate-600 dark:text-slate-300 leading-relaxed">
                    {service.description}
                  </p>
                  <div className="mt-6 flex items-center text-blue-600 dark:text-blue-400 font-medium opacity-0 group-hover:opacity-100 transition-opacity">
                    Tìm hiểu thêm <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-2 transition-transform" />
                  </div>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section id="features" className="py-24 px-4 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900 relative overflow-hidden">
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25 [mask-image:radial-gradient(ellipse_at_center,transparent_20%,black)]" />

        <div className="container mx-auto relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-16"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Award className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Ưu Điểm Vượt Trội</span>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-slate-900 dark:text-white">
              Tại Sao Chọn <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">EZDEV</span>?
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
              Chúng tôi cam kết mang đến giá trị vượt trội và trải nghiệm tuyệt vời nhất
            </p>
          </motion.div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-6xl mx-auto">
            {features.map((feature, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                whileHover={{ y: -8 }}
                className="relative group"
              >
                <div className="bg-white dark:bg-slate-800 p-8 rounded-2xl border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 h-full shadow-lg hover:shadow-2xl">
                  <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-2xl flex items-center justify-center mx-auto mb-6 shadow-lg shadow-blue-500/30 group-hover:scale-110 group-hover:rotate-6 transition-all duration-300">
                    <feature.icon className="w-8 h-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold mb-3 text-slate-900 dark:text-white text-center">
                    {feature.title}
                  </h3>
                  <p className="text-slate-600 dark:text-slate-300 text-center leading-relaxed">
                    {feature.description}
                  </p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Tech Stack Section */}
      <section id="tech" className="py-24 px-4 bg-white dark:bg-slate-900">
        <div className="container mx-auto">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-16"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Code2 className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Công Nghệ Hiện Đại</span>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-slate-900 dark:text-white">
              Tech Stack <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Mạnh Mẽ</span>
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
              Sử dụng các công nghệ tiên tiến và được tin dùng nhất trên thế giới
            </p>
          </motion.div>

          <motion.div
            initial={{ opacity: 0 }}
            whileInView={{ opacity: 1 }}
            viewport={{ once: true }}
            className="flex flex-wrap justify-center gap-4 max-w-5xl mx-auto"
          >
            {techStack.map((tech, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, scale: 0.8 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.05 }}
                whileHover={{ scale: 1.05, y: -2 }}
                className="group relative"
              >
                <div className="absolute inset-0 bg-gradient-to-r from-blue-500 to-cyan-500 rounded-2xl opacity-0 group-hover:opacity-100 blur transition-opacity" />
                <div className="relative px-8 py-4 bg-white dark:bg-slate-800 border-2 border-slate-200 dark:border-slate-700 rounded-2xl font-semibold text-slate-700 dark:text-slate-300 group-hover:border-blue-400 dark:group-hover:border-blue-500 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-all cursor-pointer shadow-md group-hover:shadow-xl">
                  {tech}
                </div>
              </motion.div>
            ))}
          </motion.div>
        </div>
      </section>

      {/* Process Section */}
      <section className="py-24 px-4 bg-gradient-to-br from-blue-50 via-cyan-50 to-teal-50 dark:from-slate-900 dark:via-blue-950 dark:to-slate-900 relative overflow-hidden">
        <div className="absolute inset-0 bg-grid-slate-200/50 dark:bg-grid-slate-700/25" />

        <div className="container mx-auto relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-16"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-blue-100 dark:bg-blue-900/30 rounded-full mb-6 border border-blue-200 dark:border-blue-800">
              <Rocket className="w-4 h-4 text-blue-600" />
              <span className="text-sm font-medium text-blue-700 dark:text-blue-300">Quy Trình Chuyên Nghiệp</span>
            </div>
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-slate-900 dark:text-white">
              Cách Chúng Tôi <span className="bg-gradient-to-r from-blue-600 to-cyan-600 bg-clip-text text-transparent">Làm Việc</span>
            </h2>
            <p className="text-xl text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
              Quy trình minh bạch, hiệu quả, đảm bảo chất lượng từng bước
            </p>
          </motion.div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-6xl mx-auto">
            {[
              {
                step: "01",
                title: "Tư Vấn & Phân Tích",
                desc: "Lắng nghe nhu cầu, phân tích yêu cầu chi tiết, đề xuất giải pháp tối ưu",
                icon: Users
              },
              {
                step: "02",
                title: "Thiết Kế & Lên Kế Hoạch",
                desc: "Thiết kế UI/UX, kiến trúc hệ thống, lập roadmap rõ ràng",
                icon: Sparkles
              },
              {
                step: "03",
                title: "Phát Triển & Testing",
                desc: "Code chất lượng cao, test tự động, review kỹ lưỡng",
                icon: Code2
              },
              {
                step: "04",
                title: "Triển Khai & Hỗ Trợ",
                desc: "Deploy an toàn, monitoring 24/7, support liên tục",
                icon: Rocket
              }
            ].map((process, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                whileHover={{ y: -5 }}
                className="relative group"
              >
                <div className="bg-white dark:bg-slate-800 rounded-2xl p-8 border border-slate-200 dark:border-slate-700 hover:border-blue-300 dark:hover:border-blue-600 transition-all duration-300 h-full shadow-lg hover:shadow-2xl">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="text-5xl font-bold bg-gradient-to-br from-blue-500 to-cyan-500 bg-clip-text text-transparent">
                      {process.step}
                    </div>
                    <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center shadow-lg shadow-blue-500/30 group-hover:scale-110 transition-transform">
                      <process.icon className="w-6 h-6 text-white" />
                    </div>
                  </div>
                  <h3 className="text-xl font-bold mb-3 text-slate-900 dark:text-white">
                    {process.title}
                  </h3>
                  <p className="text-slate-600 dark:text-slate-300 leading-relaxed">
                    {process.desc}
                  </p>
                </div>
                {index < 3 && (
                  <div className="hidden lg:block absolute top-1/2 -right-4 z-20">
                    <ArrowRight className="w-8 h-8 text-blue-400" />
                  </div>
                )}
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section id="contact" className="py-24 px-4 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-600 via-cyan-600 to-teal-600" />
        <div className="absolute inset-0 bg-grid-white/10" />
        <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-white/10 rounded-full blur-3xl" />
        <div className="absolute bottom-0 left-0 w-[500px] h-[500px] bg-white/10 rounded-full blur-3xl" />

        <div className="container mx-auto text-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 bg-white/20 backdrop-blur-sm rounded-full mb-8 border border-white/30">
              <Sparkles className="w-4 h-4 text-white" />
              <span className="text-sm font-medium text-white">Bắt Đầu Ngay Hôm Nay</span>
            </div>

            <h2 className="text-4xl md:text-6xl font-bold text-white mb-6 leading-tight">
              Sẵn Sàng Biến Ý Tưởng<br />Thành Hiện Thực?
            </h2>
            <p className="text-xl md:text-2xl text-white/90 mb-10 max-w-2xl mx-auto leading-relaxed">
              Hãy để EZDEV đồng hành cùng bạn trong hành trình chuyển đổi số và phát triển bền vững
            </p>

            <div className="flex gap-4 justify-center flex-wrap mb-12">
              <Link href="/lien-he">
                <Button size="lg" className="bg-white text-blue-600 hover:bg-blue-50 text-lg px-10 py-7 shadow-2xl hover:shadow-white/20 hover:scale-105 transition-all">
                  Tư Vấn Miễn Phí <ArrowRight className="ml-2 w-5 h-5" />
                </Button>
              </Link>
              <a href="tel:0123456789">
                <Button size="lg" variant="outline" className="text-lg px-10 py-7 bg-transparent text-white border-2 border-white hover:bg-white hover:text-blue-600 transition-all">
                  Gọi Ngay: 0123 456 789
                </Button>
              </a>
            </div>

            <div className="flex flex-wrap justify-center gap-8 text-white/90">
              <div className="flex items-center gap-2">
                <CheckCircle2 className="w-5 h-5" />
                <span>Tư vấn miễn phí</span>
              </div>
              <div className="flex items-center gap-2">
                <CheckCircle2 className="w-5 h-5" />
                <span>Báo giá trong 24h</span>
              </div>
              <div className="flex items-center gap-2">
                <CheckCircle2 className="w-5 h-5" />
                <span>Hỗ trợ 24/7</span>
              </div>
            </div>
          </motion.div>
        </div>
      </section>

      <Footer />
    </div>
  );
}
