"use client";

import { Code2, ArrowRight, Mail, Phone, MapPin } from "lucide-react";
import Link from "next/link";

export default function Footer() {
  return (
    <footer className="py-16 px-4 bg-slate-900 dark:bg-slate-950 border-t border-slate-800">
      <div className="container mx-auto">
        <div className="grid md:grid-cols-4 gap-12 mb-12">
          <div>
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-10 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-xl flex items-center justify-center shadow-lg shadow-blue-500/30">
                <Code2 className="w-6 h-6 text-white" />
              </div>
              <h3 className="text-2xl font-bold bg-gradient-to-r from-blue-400 to-cyan-400 bg-clip-text text-transparent">
                EZDEV
              </h3>
            </div>
            <p className="text-slate-400 leading-relaxed mb-4">
              Đội ngũ chuyên gia phát triển phần mềm, mang đến giải pháp công nghệ tối ưu cho doanh nghiệp
            </p>
            <div className="flex gap-3">
              {['facebook', 'twitter', 'linkedin', 'github'].map((social) => (
                <a 
                  key={social}
                  href="#" 
                  className="w-10 h-10 bg-slate-800 hover:bg-gradient-to-br hover:from-blue-500 hover:to-cyan-500 rounded-lg flex items-center justify-center transition-all hover:scale-110"
                >
                  <span className="text-slate-400 hover:text-white text-xs font-bold uppercase">{social[0]}</span>
                </a>
              ))}
            </div>
          </div>
          
          <div>
            <h4 className="font-bold text-white mb-4 text-lg">Dịch Vụ</h4>
            <ul className="space-y-3">
              {['Web Development', 'Mobile Development', 'Custom Software', 'API Development', 'DevOps & Cloud', 'Team Augmentation'].map((service) => (
                <li key={service}>
                  <Link href="/dich-vu" className="text-slate-400 hover:text-blue-400 transition-colors flex items-center gap-2 group">
                    <ArrowRight className="w-4 h-4 opacity-0 group-hover:opacity-100 -ml-6 group-hover:ml-0 transition-all" />
                    {service}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
          
          <div>
            <h4 className="font-bold text-white mb-4 text-lg">Công Ty</h4>
            <ul className="space-y-3">
              {[
                { label: 'Về Chúng Tôi', href: '/gioi-thieu' },
                { label: 'Portfolio', href: '/du-an' },
                { label: 'Case Studies', href: '/du-an' },
                { label: 'Blog', href: '#' },
                { label: 'Tuyển Dụng', href: '#' },
                { label: 'Liên Hệ', href: '/lien-he' }
              ].map((item) => (
                <li key={item.label}>
                  <Link href={item.href} className="text-slate-400 hover:text-blue-400 transition-colors flex items-center gap-2 group">
                    <ArrowRight className="w-4 h-4 opacity-0 group-hover:opacity-100 -ml-6 group-hover:ml-0 transition-all" />
                    {item.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
          
          <div>
            <h4 className="font-bold text-white mb-4 text-lg">Liên Hệ</h4>
            <ul className="space-y-4">
              <li className="flex items-start gap-3 text-slate-400">
                <Mail className="w-5 h-5 text-blue-400 mt-0.5 flex-shrink-0" />
                <div>
                  <div className="text-sm text-slate-500 mb-1">Email</div>
                  <a href="mailto:info@ezdev.vn" className="hover:text-blue-400 transition-colors">
                    info@ezdev.vn
                  </a>
                </div>
              </li>
              <li className="flex items-start gap-3 text-slate-400">
                <Phone className="w-5 h-5 text-blue-400 mt-0.5 flex-shrink-0" />
                <div>
                  <div className="text-sm text-slate-500 mb-1">Hotline</div>
                  <a href="tel:0123456789" className="hover:text-blue-400 transition-colors">
                    0123 456 789
                  </a>
                </div>
              </li>
              <li className="flex items-start gap-3 text-slate-400">
                <MapPin className="w-5 h-5 text-blue-400 mt-0.5 flex-shrink-0" />
                <div>
                  <div className="text-sm text-slate-500 mb-1">Địa chỉ</div>
                  <span>Hà Nội, Việt Nam</span>
                </div>
              </li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-slate-800 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center gap-4">
            <p className="text-slate-400 text-sm">
              &copy; 2024 EZDEV. All rights reserved. Made with <span className="text-red-500">❤️</span> in Vietnam
            </p>
            <div className="flex gap-6 text-sm">
              <a href="#" className="text-slate-400 hover:text-blue-400 transition-colors">Privacy Policy</a>
              <a href="#" className="text-slate-400 hover:text-blue-400 transition-colors">Terms of Service</a>
              <a href="#" className="text-slate-400 hover:text-blue-400 transition-colors">Cookie Policy</a>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}

